using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.P2P;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct GetNextReceivedPacketSizeOptionsInternal : ISettable<GetNextReceivedPacketSizeOptions>, IDisposable
{
	private int m_ApiVersion;

	private IntPtr m_LocalUserId;

	private IntPtr m_RequestedChannel;

	public void Set(ref GetNextReceivedPacketSizeOptions other)
	{
		m_ApiVersion = 2;
		m_LocalUserId = other.LocalUserId.InnerHandle;
		m_RequestedChannel = IntPtr.Zero;
		if (other.RequestedChannel.HasValue)
		{
			m_RequestedChannel = Helper.AddPinnedBuffer(other.m_RequestedChannel);
		}
	}

	public void Set(ref GetNextReceivedPacketSizeOptions? other)
	{
		if (other.HasValue)
		{
			m_ApiVersion = 2;
			m_LocalUserId = other.Value.LocalUserId.InnerHandle;
			m_RequestedChannel = IntPtr.Zero;
			if (other.Value.RequestedChannel.HasValue)
			{
				m_RequestedChannel = Helper.AddPinnedBuffer(other.Value.m_RequestedChannel);
			}
		}
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_LocalUserId);
		Helper.Dispose(ref m_RequestedChannel);
	}
}
