using System;

namespace Epic.OnlineServices.RTCData;

public sealed class RTCDataInterface : Handle
{
	public const int AddnotifydatareceivedApiLatest = 1;

	public const int AddnotifyparticipantupdatedApiLatest = 1;

	public const int MaxPacketSize = 1170;

	public const int SenddataApiLatest = 1;

	public const int UpdatereceivingApiLatest = 1;

	public const int UpdatesendingApiLatest = 1;

	public RTCDataInterface()
	{
	}

	public RTCDataInterface(IntPtr innerHandle)
		: base(innerHandle)
	{
	}

	public ulong AddNotifyDataReceived(ref AddNotifyDataReceivedOptions options, object clientData, OnDataReceivedCallback completionDelegate)
	{
		AddNotifyDataReceivedOptionsInternal options2 = default(AddNotifyDataReceivedOptionsInternal);
		options2.Set(ref options);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnDataReceivedCallbackInternal onDataReceivedCallbackInternal = OnDataReceivedCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionDelegate, onDataReceivedCallbackInternal);
		ulong num = Bindings.EOS_RTCData_AddNotifyDataReceived(base.InnerHandle, ref options2, clientDataAddress, onDataReceivedCallbackInternal);
		Helper.Dispose(ref options2);
		Helper.AssignNotificationIdToCallback(clientDataAddress, num);
		return num;
	}

	public ulong AddNotifyParticipantUpdated(ref AddNotifyParticipantUpdatedOptions options, object clientData, OnParticipantUpdatedCallback completionDelegate)
	{
		AddNotifyParticipantUpdatedOptionsInternal options2 = default(AddNotifyParticipantUpdatedOptionsInternal);
		options2.Set(ref options);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnParticipantUpdatedCallbackInternal onParticipantUpdatedCallbackInternal = OnParticipantUpdatedCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionDelegate, onParticipantUpdatedCallbackInternal);
		ulong num = Bindings.EOS_RTCData_AddNotifyParticipantUpdated(base.InnerHandle, ref options2, clientDataAddress, onParticipantUpdatedCallbackInternal);
		Helper.Dispose(ref options2);
		Helper.AssignNotificationIdToCallback(clientDataAddress, num);
		return num;
	}

	public void RemoveNotifyDataReceived(ulong notificationId)
	{
		Bindings.EOS_RTCData_RemoveNotifyDataReceived(base.InnerHandle, notificationId);
		Helper.RemoveCallbackByNotificationId(notificationId);
	}

	public void RemoveNotifyParticipantUpdated(ulong notificationId)
	{
		Bindings.EOS_RTCData_RemoveNotifyParticipantUpdated(base.InnerHandle, notificationId);
		Helper.RemoveCallbackByNotificationId(notificationId);
	}

	public Result SendData(ref SendDataOptions options)
	{
		SendDataOptionsInternal options2 = default(SendDataOptionsInternal);
		options2.Set(ref options);
		Result result = Bindings.EOS_RTCData_SendData(base.InnerHandle, ref options2);
		Helper.Dispose(ref options2);
		return result;
	}

	public void UpdateReceiving(ref UpdateReceivingOptions options, object clientData, OnUpdateReceivingCallback completionDelegate)
	{
		UpdateReceivingOptionsInternal options2 = default(UpdateReceivingOptionsInternal);
		options2.Set(ref options);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnUpdateReceivingCallbackInternal onUpdateReceivingCallbackInternal = OnUpdateReceivingCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionDelegate, onUpdateReceivingCallbackInternal);
		Bindings.EOS_RTCData_UpdateReceiving(base.InnerHandle, ref options2, clientDataAddress, onUpdateReceivingCallbackInternal);
		Helper.Dispose(ref options2);
	}

	public void UpdateSending(ref UpdateSendingOptions options, object clientData, OnUpdateSendingCallback completionDelegate)
	{
		UpdateSendingOptionsInternal options2 = default(UpdateSendingOptionsInternal);
		options2.Set(ref options);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnUpdateSendingCallbackInternal onUpdateSendingCallbackInternal = OnUpdateSendingCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionDelegate, onUpdateSendingCallbackInternal);
		Bindings.EOS_RTCData_UpdateSending(base.InnerHandle, ref options2, clientDataAddress, onUpdateSendingCallbackInternal);
		Helper.Dispose(ref options2);
	}

	[MonoPInvokeCallback(typeof(OnDataReceivedCallbackInternal))]
	internal static void OnDataReceivedCallbackInternalImplementation(ref DataReceivedCallbackInfoInternal data)
	{
		if (Helper.TryGetCallback<DataReceivedCallbackInfoInternal, OnDataReceivedCallback, DataReceivedCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnParticipantUpdatedCallbackInternal))]
	internal static void OnParticipantUpdatedCallbackInternalImplementation(ref ParticipantUpdatedCallbackInfoInternal data)
	{
		if (Helper.TryGetCallback<ParticipantUpdatedCallbackInfoInternal, OnParticipantUpdatedCallback, ParticipantUpdatedCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnUpdateReceivingCallbackInternal))]
	internal static void OnUpdateReceivingCallbackInternalImplementation(ref UpdateReceivingCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<UpdateReceivingCallbackInfoInternal, OnUpdateReceivingCallback, UpdateReceivingCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnUpdateSendingCallbackInternal))]
	internal static void OnUpdateSendingCallbackInternalImplementation(ref UpdateSendingCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<UpdateSendingCallbackInfoInternal, OnUpdateSendingCallback, UpdateSendingCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}
}
