using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.Sanctions;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct CreatePlayerSanctionAppealCallbackInfoInternal : ICallbackInfoInternal, IGettable<CreatePlayerSanctionAppealCallbackInfo>, ISettable<CreatePlayerSanctionAppealCallbackInfo>, IDisposable
{
	private Result m_ResultCode;

	private IntPtr m_ClientData;

	private IntPtr m_ReferenceId;

	public Result ResultCode
	{
		get
		{
			return m_ResultCode;
		}
		set
		{
			m_ResultCode = value;
		}
	}

	public object ClientData
	{
		get
		{
			Helper.Get(m_ClientData, out object to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_ClientData);
		}
	}

	public IntPtr ClientDataAddress => m_ClientData;

	public Utf8String ReferenceId
	{
		get
		{
			Helper.Get(m_ReferenceId, out Utf8String to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_ReferenceId);
		}
	}

	public void Set(ref CreatePlayerSanctionAppealCallbackInfo other)
	{
		ResultCode = other.ResultCode;
		ClientData = other.ClientData;
		ReferenceId = other.ReferenceId;
	}

	public void Set(ref CreatePlayerSanctionAppealCallbackInfo? other)
	{
		if (other.HasValue)
		{
			ResultCode = other.Value.ResultCode;
			ClientData = other.Value.ClientData;
			ReferenceId = other.Value.ReferenceId;
		}
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_ClientData);
		Helper.Dispose(ref m_ReferenceId);
	}

	public void Get(out CreatePlayerSanctionAppealCallbackInfo output)
	{
		output = default(CreatePlayerSanctionAppealCallbackInfo);
		output.Set(ref this);
	}
}
