using System;

namespace Epic.OnlineServices.UI;

[Flags]
public enum KeyCombination
{
	ModifierShift = 0x10,
	KeyTypeMask = 0xFFFF,
	ModifierMask = -65536,
	Shift = 0x10000,
	Control = 0x20000,
	Alt = 0x40000,
	Meta = 0x80000,
	ValidModifierMask = 0xF0000,
	None = 0,
	Space = 1,
	Backspace = 2,
	Tab = 3,
	Escape = 4,
	PageUp = 5,
	PageDown = 6,
	End = 7,
	Home = 8,
	Insert = 9,
	Delete = 0xA,
	Left = 0xB,
	Up = 0xC,
	Right = 0xD,
	Down = 0xE,
	Key0 = 0xF,
	Key1 = 0x10,
	Key2 = 0x11,
	Key3 = 0x12,
	Key4 = 0x13,
	Key5 = 0x14,
	Key6 = 0x15,
	Key7 = 0x16,
	Key8 = 0x17,
	Key9 = 0x18,
	KeyA = 0x19,
	KeyB = 0x1A,
	KeyC = 0x1B,
	KeyD = 0x1C,
	KeyE = 0x1D,
	KeyF = 0x1E,
	KeyG = 0x1F,
	KeyH = 0x20,
	KeyI = 0x21,
	KeyJ = 0x22,
	KeyK = 0x23,
	KeyL = 0x24,
	KeyM = 0x25,
	KeyN = 0x26,
	KeyO = 0x27,
	KeyP = 0x28,
	KeyQ = 0x29,
	KeyR = 0x2A,
	KeyS = 0x2B,
	KeyT = 0x2C,
	KeyU = 0x2D,
	KeyV = 0x2E,
	KeyW = 0x2F,
	KeyX = 0x30,
	KeyY = 0x31,
	KeyZ = 0x32,
	Numpad0 = 0x33,
	Numpad1 = 0x34,
	Numpad2 = 0x35,
	Numpad3 = 0x36,
	Numpad4 = 0x37,
	Numpad5 = 0x38,
	Numpad6 = 0x39,
	Numpad7 = 0x3A,
	Numpad8 = 0x3B,
	Numpad9 = 0x3C,
	NumpadAsterisk = 0x3D,
	NumpadPlus = 0x3E,
	NumpadMinus = 0x3F,
	NumpadPeriod = 0x40,
	NumpadDivide = 0x41,
	F1 = 0x42,
	F2 = 0x43,
	F3 = 0x44,
	F4 = 0x45,
	F5 = 0x46,
	F6 = 0x47,
	F7 = 0x48,
	F8 = 0x49,
	F9 = 0x4A,
	F10 = 0x4B,
	F11 = 0x4C,
	F12 = 0x4D,
	F13 = 0x4E,
	F14 = 0x4F,
	F15 = 0x50,
	F16 = 0x51,
	F17 = 0x52,
	F18 = 0x53,
	F19 = 0x54,
	F20 = 0x55,
	F21 = 0x56,
	F22 = 0x57,
	F23 = 0x58,
	F24 = 0x59,
	OemPlus = 0x5A,
	OemComma = 0x5B,
	OemMinus = 0x5C,
	OemPeriod = 0x5D,
	Oem1 = 0x5E,
	Oem2 = 0x5F,
	Oem3 = 0x60,
	Oem4 = 0x61,
	Oem5 = 0x62,
	Oem6 = 0x63,
	Oem7 = 0x64,
	Oem8 = 0x65,
	MaxKeyType = 0x66
}
