#version 330 core

//-------------------------------------------------------------------------------------------------------------------------
//                                  Shader Params
//-------------------------------------------------------------------------------------------------------------------------
uniform mat4 uModelMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Vertex Attributes
//-------------------------------------------------------------------------------------------------------------------------
in vec3 vertPosition;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Out
//-------------------------------------------------------------------------------------------------------------------------
#if USE_LINEAR_Z
out vec3 fragPositionVS;
#endif // USE_LINEAR_Z

//-------------------------------------------------------------------------------------------------------------------------

void main()
{
	vec4 positionVS = uViewMatrix * uModelMatrix * vec4(vertPosition, 1.0);
    gl_Position = uProjectionMatrix * positionVS;

#if USE_LINEAR_Z
	fragPositionVS = positionVS.xyz;
#endif // USE_LINEAR_Z
}
