#ifndef RANDOM_INCLUDE
#define RANDOM_INCLUDE

float random(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float n2rand_faster_animated( vec2 n , float time)
{
    float t = fract(time);
    float nrnd0 = random(n + 0.07*t);

    // Convert uniform distribution into triangle-shaped distribution.
    float orig = nrnd0*2.0-1.0;
    nrnd0 = orig*inversesqrt(abs(orig));
    nrnd0 = max(-1.0,nrnd0); // Nerf the NaN generated by 0*rsqrt(0). Thanks @FioraAeterna!
    nrnd0 = nrnd0-sign(orig)+0.5;

    // Result is range [-0.5,1.5] which is
    // useful for actual dithering.
    // convert to [0,1] for histogram.
    return (nrnd0+0.5) * 0.5;
}

float n2rand_faster( vec2 n)
{
    float nrnd0 = random(n);

    // Convert uniform distribution into triangle-shaped distribution.
    float orig = nrnd0*2.0-1.0;
    nrnd0 = orig*inversesqrt(abs(orig));
    nrnd0 = max(-1.0,nrnd0); // Nerf the NaN generated by 0*rsqrt(0). Thanks @FioraAeterna!
    nrnd0 = nrnd0-sign(orig)+0.5;

    // Result is range [-0.5,1.5] which is
    // useful for actual dithering.
    // convert to [0,1] for histogram.
    return (nrnd0+0.5) * 0.5;
}

// A single iteration of Bob Jenkins' One-At-A-Time hashing algorithm.
uint hash( uint x ) {
    x += ( x << 10u );
    x ^= ( x >>  6u );
    x += ( x <<  3u );
    x ^= ( x >> 11u );
    x += ( x << 15u );
    return x;
}

// Construct a float with half-open range [0:1] using low 23 bits.
// All zeroes yields 0.0, all ones yields the next smallest representable value below 1.0.
float floatConstruct( uint m ) {
    const uint ieeeMantissa = 0x007FFFFFu; // binary32 mantissa bitmask
    const uint ieeeOne      = 0x3F800000u; // 1.0 in IEEE binary32

    m &= ieeeMantissa;                     // Keep only mantissa bits (fractional part)
    m |= ieeeOne;                          // Add fractional part to 1.0

    float  f = uintBitsToFloat( m );       // Range [1:2]
    return f - 1.0;                        // Range [0:1]
}

// Pseudo-random value in half-open range [0:1].
float randomui( uint x ) { return floatConstruct(hash(x)); }

#endif //RANDOM_INCLUDE
