#version 330 core

//-------------------------------------------------------------------------------------------------------------------------
//                                  Shader Params
//-------------------------------------------------------------------------------------------------------------------------
uniform sampler2D uTexture;
uniform sampler2D uMaskTexture;

//-------------------------------------------------------------------------------------------------------------------------
//                                  In
//-------------------------------------------------------------------------------------------------------------------------
in vec2 fragTexCoords;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Out
//-------------------------------------------------------------------------------------------------------------------------
layout (location = 0) out vec4 outColor;

//-------------------------------------------------------------------------------------------------------------------------

void main()
{
    vec4 texel = texture(uTexture, fragTexCoords);

    if (texel.a == 0.0) discard;

    outColor.rgb = texel.rgb;
    outColor.a = texture(uMaskTexture, fragTexCoords).r;
}
