#version 330 core

//-------------------------------------------------------------------------------------------------------------------------
//                                  Shader Params
//-------------------------------------------------------------------------------------------------------------------------
uniform mat4 uModelMatrix;
uniform mat4 uViewProjectionMatrix;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Vertex Attributes
//-------------------------------------------------------------------------------------------------------------------------
in vec3 vertPosition;

#if ALPHA_TEST
in vec2 vertTexCoords;
#endif

//-------------------------------------------------------------------------------------------------------------------------
//                                  Out
//-------------------------------------------------------------------------------------------------------------------------
#if ALPHA_TEST
out vec2 fragTexCoords;
#endif

//-------------------------------------------------------------------------------------------------------------------------

void main()
{
#if ALPHA_TEST
    fragTexCoords = vertTexCoords;
#endif // ALPHA_TEST

    gl_Position = uViewProjectionMatrix * uModelMatrix * vec4(vertPosition, 1.0);
}
